/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class KitchenSinkBlock
extends FurnitureHorizontalBlock {
    private boolean bigSink;
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public KitchenSinkBlock(AbstractBlock.Properties properties, boolean bigSink) {
        super(properties);
        this.bigSink = bigSink;
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
        if (this.bigSink) {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)15.0), Direction.SOUTH))[direction.func_176736_b()]);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH))[direction.func_176736_b()]);
        } else {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH))[direction.func_176736_b()]);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH))[direction.func_176736_b()]);
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            IFluidHandler handler;
            ItemStack heldItem = playerEntity.func_184586_b(hand);
            if (!heldItem.func_190926_b() && heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                return FluidUtil.interactWithFluidHandler((PlayerEntity)playerEntity, (Hand)hand, (World)world, (BlockPos)pos, (Direction)result.func_216354_b()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
            BlockPos waterPos = pos.func_177977_b().func_177977_b();
            if (this.isWaterSource(world, waterPos) && (handler = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null).orElse(null)).getFluidInTank(0).getAmount() != handler.getTankCapacity(0)) {
                handler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
                double posX = (double)pos.func_177958_n() + 0.5 + (double)direction.func_176730_m().func_177958_n() * 0.1;
                double posY = (double)pos.func_177956_o() + 1.15;
                double posZ = (double)pos.func_177952_p() + 0.5 + (double)direction.func_176730_m().func_177952_p() * 0.1;
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218425_n, posX, posY, posZ, 10, 0.01, 0.01, 0.01, 0.0);
                int adjacentSources = 0;
                adjacentSources += this.isWaterSource(world, waterPos.func_177978_c()) ? 1 : 0;
                adjacentSources += this.isWaterSource(world, waterPos.func_177974_f()) ? 1 : 0;
                adjacentSources += this.isWaterSource(world, waterPos.func_177968_d()) ? 1 : 0;
                if ((adjacentSources += this.isWaterSource(world, waterPos.func_177976_e()) ? 1 : 0) < 2) {
                    world.func_175656_a(waterPos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private boolean isWaterSource(World world, BlockPos pos) {
        return world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KitchenSinkTileEntity();
    }
}

